@echo off
rem v1.0--original
rem v1.1--added multiple recipe processing
rem v1.2--handle Windows XP and Vista/7 differences in Calibre and user directory locations
rem v1.3--use START for ebook-convert to work-around Windows XP problem
rem v1.4--use --duplicates parameter in caliberdb add
REM V1.5--control appending of asterisk to periodical title in news-set-vars.bat
SETLOCAL EnableDelayedExpansion

call Calibre-Kindle\Recipes\Resources\news-set-vars.bat
if %errorlevel%==0 goto :oksetvars
echo.
if %errorlevel%==1 echo ERROR: news-set-vars.bat cannot find BUILTIN_RECIPES.ZIP
if %errorlevel%==2 echo ERROR: news-set-vars.bat cannot find directory Python27
echo        Please correct the file and try again
echo.
goto :done
:oksetvars
set numfiles=0
set email=
set add=
set user=
set userid=
set password=
set pause=
set verbose=
set options=

if "%1" neq "" goto :okfile
:showformat
echo.
echo USAGE:   news recipename ... [-email] [-add] [-user userid password] [-verbose] 
echo                              [-pause] [-options ...]
echo.
echo Download the periodicals defined by one or more recipes
echo.
echo If the directory Calibre-Kindle\Recipes contains the file
echo recipename.recipe it wil be used
echo.
echo Otherwise, the built-in recipe called recipename will be 
echo loaded from the Calibre release directory specified in
echo news-set-vars.bat
echo.
echo OPTIONS: -email    send the file to email as specified in news-set-vars.bat                 
echo          -add      add the file to the calibre library
echo          -user     pass the supplied login userid and password to the recipe
echo          -verbose  use verbose mode for Calibre commands
echo          -pause    pause at then end of the script to prevent window from closing
echo          -options  take balance of command line (up to 9 tokens) as additional 
echo                    options for ebook-convert. This must come after all the recipe
echo                    names and also be the last option on the command line.                 
echo.
set pause=yes
goto :done

:okfile
cd Calibre-Kindle\Recipes

:argloop

if "%1"=="" goto :okparams
if %1 neq -options goto :notoptions
shift
set options=%1 %2 %3 %4 %5 %6 %7 %8 %9
goto :okparams

:notoptions
if %1 neq -email goto :notemail
set email=yes
goto :nextarg

:notemail
if %1 neq -add goto :notadd
set add=yes
goto :nextarg

:notadd
if %1 neq -user goto :notuser
set user=yes
shift
if "%1" neq "" goto :okuser
echo.
echo ERROR: -user specified but userid and password missing
echo.
cd ..\..
goto :showformat
:okuser
set userid=%1
shift
if "%1" neq "" goto :okpw
echo.
echo ERROR: -user specified but password missing
echo.
cd ..\..
goto :showformat
:okpw
set password=%1
goto :nextarg

:notuser
if %1 neq -verbose goto :notverbose
set verbose=--verbose
goto :nextarg

:notverbose
if %1 == -pause goto :ispause
set /a numfiles +=1
set fname%numfiles%=%1
goto :nextarg

:ispause
set pause=yes

:nextarg
shift
goto :argloop

:okparams
if %numfiles% neq 0 goto :okparams1
echo.
echo You must specify at least one recipe
cd ..\..
goto :showformat

:okparams1
for /l %%X in (1,1,%numfiles%) do (echo Recipe !fname%%X!)
echo email=%email%
echo add=%add%
echo user=%user%
echo userid=%userid%
echo password=%password%
echo pause=%pause%
echo verbose=%verbose%
echo options=%options%

set indx=0

:docloop

set /a indx+=1
if %indx% leq %numfiles% goto :okdocloop
cd ..\..
echo.
echo Recipe processing complete
echo.
goto :done

:okdocloop
set fname=!fname%indx%!
set CALIBRE_RECIPE_NAME=%fname%
if exist Temp\%fname%.recipe erase Temp\%fname%.recipe
echo Updating recipe %fname% ...
%PYTHONDIR%python Resources\update-recipe.py %fname%
if exist Temp\%fname%.recipe goto :okupdate
echo.
echo ERROR: Recipe update for %fname% failed
echo.
goto :docloop

:okupdate
cd Temp
if exist %fname%.oeb\%fname%.opf erase %fname%.oeb\%fname%.opf
echo Downloading periodical %fname% ...
if "%verbose%"=="" goto :startcmd
echo.
echo VERBOSE processing...you will have to type "EXIT" in the new window to close it and continue
echo.
start /wait ..\Resources\ebook.bat
goto :checkmobi
:startcmd
if "%user%" == "" goto :nologin
start /wait ebook-convert %fname%.recipe %fname%.oeb --output-profile=kindle --username=%userid% --password=%password% %verbose% %options%
goto :checkmobi
:nologin
start /wait ebook-convert %fname%.recipe %fname%.oeb --output-profile=kindle %verbose% %options%
:checkmobi
if exist %fname%.ncx goto :okebook
echo.
echo ERROR: Periodical %fname% download failed
echo.
echo Run NEWS %fname% -verbose to see the output from ebook-convert
cd ..
goto :docloop

:okebook
copy /Y %fname%.ncx %fname%.oeb\%fname%.ncx
copy /Y %fname%.opf %fname%.oeb\%fname%.opf
erase %fname%.ncx
erase %fname%.opf
cd %fname%.oeb
if exist %fname%.mobi erase %fname%.mobi
echo Generating Kindle file for %fname% ...
..\..\Resources\kindlegen %fname%.opf -c1 -o %fname%.mobi >%fname%-log.txt
if exist %fname%.mobi goto :okall
echo.
echo ERROR: Kindlegen for %fname% failed
echo.
echo Check Temp\%fname%.oeb\%fname%-log.txt for error details
cd ..\..
goto :docloop

:okall
copy /Y %fname%.mobi ..\..\..\News-Files\%fname%.mobi
echo File generation for %fname% complete

if "%email%" == "" goto :checkadd
echo Emailing %fname%.mobi to %EMAIL_RECIPIENT% ...
calibre-smtp  -a %fname%.mobi -s %fname% -e %EMAIL_ENCRYPTION% -p %EMAIL_PASSWORD% --port %EMAIL_PORT% -r %EMAIL_HOSTNAME% -u %EMAIL_USERNAME%  %verbose% %EMAIL_USERNAME% %EMAIL_RECIPIENT% "Converted %fname%"

:checkadd
if "%add%" == "" goto :endloop
echo Adding %fname%.mobi to Calibre library ...
calibredb add %fname%.mobi --duplicates >%fname%-add-log.txt

:endloop
cd ..\..
goto :docloop

:done
if "%pause%" neq "" pause



